/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.sas;

import com.ibm.hwmca.base.custinfo.CustomerInfoData;
import com.ibm.hwmca.base.custinfo.CustomerInfoManager;
import com.ibm.hwmca.base.rsf.requests.BaseRsfRequestErrorIds;
import com.ibm.hwmca.base.rsf.sas.ChangePasswordRequestBody;
import com.ibm.hwmca.base.rsf.sas.ChangePasswordSchedulable;
import com.ibm.hwmca.base.rsf.sas.CredentialCompletionStatus;
import com.ibm.hwmca.base.rsf.sas.CredentialResult;
import com.ibm.hwmca.base.rsf.sas.CredentialStore;
import com.ibm.hwmca.base.rsf.sas.CredentialStoreAccessException;
import com.ibm.hwmca.base.rsf.sas.EnrollmentRequestBody;
import com.ibm.hwmca.base.rsf.sas.LocalCredentialStore;
import com.ibm.hwmca.base.rsf.sas.UnsupportedTargetException;
import com.ibm.hwmca.base.rsf.sas.UpdateSystemRequestBody;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.rcs.sas.ClientLocation;
import com.ibm.hwmca.fw.rcs.sas.CompanyIdentifier;
import com.ibm.hwmca.fw.rcs.sas.LicenseAcceptance;
import com.ibm.hwmca.fw.rcs.sas.PSeriesEnrollment;
import com.ibm.hwmca.fw.rcs.sas.RegisterUsers;
import com.ibm.hwmca.fw.rcs.sas.SysInfo;
import com.ibm.hwmca.fw.rcs.sas.SystemIdentifier;
import com.ibm.hwmca.fw.rcs.sas.XSeriesEnrollment;
import com.ibm.hwmca.fw.rcs.sas.ZSeriesEnrollment;
import com.ibm.hwmca.fw.rsf.RemoteSupportFacility;
import com.ibm.hwmca.fw.rsf.RsfManager;
import com.ibm.hwmca.fw.rsf.RsfRequest;
import com.ibm.hwmca.fw.rsf.RsfResult;
import com.ibm.hwmca.fw.rsf.RsfResultDetails;
import com.ibm.hwmca.fw.rsf.RsfResultProcessor;
import com.ibm.hwmca.fw.schedops.HMCScheduler;
import com.ibm.hwmca.fw.schedops.Schedule;
import com.ibm.hwmca.fw.schedops.ScheduledOperation;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class CredentialUtils
implements RsfResultProcessor,
BaseRsfRequestErrorIds {
    private static final String TRACE_MASKT = "XRSFCR T";
    private static final String TRACE_MASKF = "XRSFCR F";
    private static final String TRACE_MASKD = "XRSFCR D";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-44, "System Auth");
    private static FrameworkLogAttributes infoLog = FrameworkLogAttributes.INFO_LOG;
    private static FrameworkLogAttributes infoLogDisplayError = new FrameworkLogAttributes(false, false, true, true, true, true, false, 0);
    private static HashMap outstandingRequests = new HashMap();
    private static String CLASSNAME = "com.ibm.hwmca.base.rsf.sas.CredentialUtils";
    private static String bundleName = "com/ibm/hwmca/base/rsf/res/BaseRsfRes";
    public static int credentialTimeout = 300000;
    public static boolean credentialDataTest = false;
    public static long changePasswordFrequency = 30L;
    public static long changePasswordRetry = 21L;
    static /* synthetic */ Class class$com$ibm$hwmca$base$rsf$sas$CredentialStore;
    static /* synthetic */ Class class$com$ibm$hwmca$base$rsf$sas$LocalCredentialStore;

    public static CredentialStore getCredentialStoreImpl(String storeName) {
        Trace.trace(TRACE_MASKF, "CredentialUtils.getCredentialStoreImpl for " + storeName);
        if (storeName == null) {
            return null;
        }
        Class<?> implClass = null;
        try {
            implClass = Class.forName(storeName);
        }
        catch (ClassNotFoundException e) {
            Trace.trace(TRACE_MASKT, "<- CredentialUtils.getCredentialStoreImpl() returning null, implementation class not found");
            return null;
        }
        Class[] noargs = new Class[]{};
        Method factory = null;
        try {
            factory = implClass.getDeclaredMethod("getCredentialStore", noargs);
        }
        catch (NoSuchMethodException e) {
            Trace.trace(TRACE_MASKT, "<- CredentialUtils.getCredentialStoreImpl() returning null, no 'getCredentialStore()' method found in impl class");
            return null;
        }
        int mod = factory.getModifiers();
        if (!((class$com$ibm$hwmca$base$rsf$sas$CredentialStore == null ? (class$com$ibm$hwmca$base$rsf$sas$CredentialStore = CredentialUtils.class$("com.ibm.hwmca.base.rsf.sas.CredentialStore")) : class$com$ibm$hwmca$base$rsf$sas$CredentialStore).isAssignableFrom(factory.getReturnType()) && Modifier.isPublic(mod) && Modifier.isStatic(mod))) {
            Trace.trace(TRACE_MASKT, "<- CredentialUtils.getCredentialStoreImpl() returning null, return type or modifiers for 'getCredentialStore()' are wrong");
            return null;
        }
        CredentialStore storeImpl = null;
        try {
            storeImpl = (CredentialStore)factory.invoke(null, null);
            Trace.trace(TRACE_MASKT, "<- CredentialUtils.getCredentialStoreImpl() Found: " + storeName);
            return storeImpl;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<- CredentialUtils.getCredentialStoreImpl() returning null, invocation of factory method threw an exception");
            return null;
        }
    }

    public static SysInfo getLocalCredentials() throws CredentialStoreAccessException {
        try {
            return LocalCredentialStore.getCredentialStore().getCredential(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void clearLocalCredentials() {
        try {
            LocalCredentialStore.getCredentialStore().clearCredential(null);
        }
        catch (Exception e) {}
    }

    public static SysInfo getCachedCredentials(Object target) throws UnsupportedTargetException, CredentialStoreAccessException {
        return LocalCredentialStore.getCredentialStore().getCredential(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CredentialResult getNewLocalCredentialsSynchronous() {
        Trace.trace(TRACE_MASKT, "-> CredentialUtils::getNewLocalCredentialsSynchronous()");
        SystemIdentifier sysIdentifier = LocalCredentialStore.getLocalSystemIdentifier();
        EnrollmentRequestBody enroll = new EnrollmentRequestBody(sysIdentifier, CredentialUtils.getLocalClientLocation(), CredentialUtils.getLocalCompanyIdentifier(), null, null, null, null, null);
        CredentialResult result = new CredentialResult();
        result.setTarget(null);
        result.setStatus(CredentialCompletionStatus.RESOURCE_UNAVAILABLE);
        try {
            Trace.trace(TRACE_MASKD, "CredentialUtils: get rsf");
            RemoteSupportFacility rsf = RsfManager.getRsfManager().getConsoleRsf();
            if (rsf == null) {
                Trace.trace(TRACE_MASKD, "CredentialUtils: rsf null");
                return result;
            }
            Trace.trace(TRACE_MASKD, "CredentialUtils: got RemoteSupport Facility");
            RsfRequest req = rsf.newRequestInstance(enroll, CLASSNAME, new LocalizableText(bundleName, "RsfCredentials.Enroll"));
            String id = req.getId();
            Trace.trace(TRACE_MASKD, "CredentialUtils: got new request instance:" + id);
            result.setStatus(CredentialCompletionStatus.TIMEOUT);
            outstandingRequests.put(id, result);
            req.submit();
            Trace.trace(TRACE_MASKD, "CredentialUtils: submitted request");
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "CredentialUtils: Rsf Submission Error ");
            Trace.trace(TRACE_MASKF, e);
            return result;
        }
        CredentialResult credentialResult = result;
        synchronized (credentialResult) {
            SysInfo credentials;
            if (!result.isCompleted()) {
                try {
                    result.wait(credentialTimeout);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (!result.isCompleted()) {
                CredentialUtils.logError("CredentialUtils.getNewLocalCredentials: Timeout waiting for result", null, (short)12548);
            }
            if ((credentials = result.getCredentials()) != null) {
                try {
                    LocalCredentialStore.getCredentialStore().storeLocalCredential(credentials, sysIdentifier);
                }
                catch (Exception e) {
                    result.setStatus(CredentialCompletionStatus.CREDENTIAL_STORE_FAILURE);
                }
            }
            result.setCompleted(true);
        }
        CredentialCompletionStatus status = result.getStatus();
        if (status.equals(CredentialCompletionStatus.SUCCESS)) {
            Trace.trace(TRACE_MASKF, "New local credentials obtained.  Will start change password schedulable");
            CredentialUtils.logInfo("Get new credentials for local machine successful", null, (short)12552);
            CredentialUtils.cleanupPasswordScheduleAndRemove(null, true);
            CredentialUtils.startPasswordSchedule(null, (class$com$ibm$hwmca$base$rsf$sas$LocalCredentialStore == null ? (class$com$ibm$hwmca$base$rsf$sas$LocalCredentialStore = CredentialUtils.class$("com.ibm.hwmca.base.rsf.sas.LocalCredentialStore")) : class$com$ibm$hwmca$base$rsf$sas$LocalCredentialStore).getName());
        } else if (status.equals(CredentialCompletionStatus.TIMEOUT)) {
            CredentialUtils.logError("CredentialUtils.getNewLocalCredentials: Timeout waiting for result", null, (short)12548);
        } else {
            CredentialUtils.logError("Status from get new credentials: " + status, null, (short)12548);
        }
        Trace.trace(TRACE_MASKT, "<- /CredentialUtils::getNewLocalCredentialsSynchronous()");
        return result;
    }

    public static SysInfo getCredentials(Object target, CredentialStore impl) throws UnsupportedTargetException, CredentialStoreAccessException {
        return impl.getCredential(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CredentialResult getNewCredentialsSynchronous(Object target, CredentialStore impl) throws UnsupportedTargetException {
        Trace.trace(TRACE_MASKT, "-> CredentialUtils::getNewCredentialsSynchronous()");
        EnrollmentRequestBody enroll = new EnrollmentRequestBody(CredentialUtils.getSystemIdentifier(target), CredentialUtils.getClientLocation(target), CredentialUtils.getCompanyIdentifier(target), null, null, null, null, null);
        CredentialResult result = new CredentialResult();
        result.setTarget(target);
        result.setStatus(CredentialCompletionStatus.RESOURCE_UNAVAILABLE);
        try {
            Trace.trace(TRACE_MASKD, "CredentialUtils: get rsf");
            RemoteSupportFacility rsf = RsfManager.getRsfManager().getConsoleRsf();
            if (rsf == null) {
                Trace.trace(TRACE_MASKD, "CredentialUtils: rsf null");
                return result;
            }
            Trace.trace(TRACE_MASKD, "CredentialUtils: got RemoteSupport Facility");
            RsfRequest req = rsf.newRequestInstance(enroll, CLASSNAME, new LocalizableText(bundleName, "RsfCredentials.Enroll"));
            String id = req.getId();
            Trace.trace(TRACE_MASKD, "CredentialUtils: got new request instance:" + id);
            result.setStatus(CredentialCompletionStatus.TIMEOUT);
            outstandingRequests.put(id, result);
            req.submit();
            Trace.trace(TRACE_MASKD, "CredentialUtils: submitted request");
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "CredentialUtils: Rsf Submission Error ");
            Trace.trace(TRACE_MASKF, e);
            return result;
        }
        CredentialResult credentialResult = result;
        synchronized (credentialResult) {
            SysInfo credentials;
            if (!result.isCompleted()) {
                try {
                    result.wait(credentialTimeout);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if ((credentials = result.getCredentials()) != null) {
                try {
                    impl.storeCredential(target, credentials);
                }
                catch (Exception e) {
                    result.setStatus(CredentialCompletionStatus.CREDENTIAL_STORE_FAILURE);
                }
            }
            result.setCompleted(true);
        }
        CredentialCompletionStatus status = result.getStatus();
        if (status.equals(CredentialCompletionStatus.SUCCESS)) {
            Trace.trace(TRACE_MASKF, "Got new credentials for " + target + ". Will start change password sched op");
            CredentialUtils.logInfo("Get new credentials for " + target + " machine successful", null, (short)12552);
            CredentialUtils.cleanupPasswordScheduleAndRemove((String)target, true);
            CredentialUtils.startPasswordSchedule((String)target, impl.getClass().getName());
        } else if (status.equals(CredentialCompletionStatus.TIMEOUT)) {
            CredentialUtils.logError("CredentialUtils.getNewCredentials: Timeout waiting for result", null, (short)12548);
        } else {
            CredentialUtils.logError("Status from get new credentials for " + target + ": " + status, null, (short)12548);
        }
        Trace.trace(TRACE_MASKT, "<- /CredentialUtils::getNewCredentialsSynchronous()");
        return result;
    }

    public static CredentialCompletionStatus updateLocalPasswordSynchronous() {
        try {
            return CredentialUtils.updatePasswordSynchronous(null, LocalCredentialStore.getCredentialStore());
        }
        catch (Exception e) {
            return CredentialCompletionStatus.INTERNAL_CODE_ERROR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CredentialCompletionStatus updatePasswordSynchronous(Object target, CredentialStore impl) throws UnsupportedTargetException {
        CredentialCompletionStatus status;
        SysInfo credentials;
        Trace.trace(TRACE_MASKT, "-> CredentialUtils::updatePasswordSynchronous()");
        Trace.trace(TRACE_MASKT, "-> CredentialUtils::updateSystemCredentialInfoSynchronous()");
        try {
            credentials = impl.getCredential(target);
        }
        catch (Exception e) {
            CredentialUtils.logError("CredentialUtils: updateSystemCredentialInfo: credentials not found", e, (short)12548);
            return CredentialCompletionStatus.REQUEST_FAILURE;
        }
        if (credentials == null) {
            CredentialUtils.logError("CredentialUtils: updateSystemCredentialInfo: credentials not found", null, (short)12548);
            return CredentialCompletionStatus.REQUEST_FAILURE;
        }
        ChangePasswordRequestBody password = new ChangePasswordRequestBody(credentials);
        CredentialResult result = new CredentialResult();
        result.setTarget(target);
        result.setStatus(CredentialCompletionStatus.RESOURCE_UNAVAILABLE);
        try {
            Trace.trace(TRACE_MASKD, "CredentialUtils: get rsf");
            RemoteSupportFacility rsf = RsfManager.getRsfManager().getConsoleRsf();
            if (rsf == null) {
                Trace.trace(TRACE_MASKD, "CredentialUtils: rsf null");
                return CredentialCompletionStatus.RESOURCE_UNAVAILABLE;
            }
            Trace.trace(TRACE_MASKD, "CredentialUtils: got RemoteSupport Facility");
            RsfRequest req = rsf.newRequestInstance(password, CLASSNAME, new LocalizableText(bundleName, "RsfCredentials.Password"));
            String id = req.getId();
            Trace.trace(TRACE_MASKD, "CredentialUtils: got new request instance:" + id);
            result.setStatus(CredentialCompletionStatus.TIMEOUT);
            outstandingRequests.put(id, result);
            req.submit();
            Trace.trace(TRACE_MASKD, "CredentialUtils: submitted request");
        }
        catch (Exception e) {
            CredentialUtils.logError("CredentialUtils: Rsf Submission Error ", e, (short)12548);
            return CredentialCompletionStatus.REQUEST_FAILURE;
        }
        CredentialResult credentialResult = result;
        synchronized (credentialResult) {
            SysInfo newCredentials;
            if (!result.isCompleted()) {
                try {
                    result.wait(credentialTimeout);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if ((newCredentials = result.getCredentials()) != null) {
                try {
                    impl.storeCredential(target, newCredentials);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Store credentials for change password exception:");
                    Trace.trace(TRACE_MASKF, e);
                    result.setStatus(CredentialCompletionStatus.CREDENTIAL_STORE_FAILURE);
                }
            }
            result.setCompleted(true);
        }
        String mach = "local";
        if (target != null) {
            mach = target.toString();
        }
        if ((status = result.getStatus()).equals(CredentialCompletionStatus.SUCCESS)) {
            CredentialUtils.logInfo("Change credential password for " + mach + " machine successful", null, (short)12552);
        } else if (status.equals(CredentialCompletionStatus.TIMEOUT)) {
            CredentialUtils.logError("CredentialUtils.changePassword: Timeout waiting for result", null, (short)12548);
        } else {
            CredentialUtils.logError("Status from change credential password for " + mach + ": " + status, null, (short)12548);
        }
        Trace.trace(TRACE_MASKT, "<- CredentialUtils::updatePasswordSynchronous()");
        return status;
    }

    public static CredentialCompletionStatus updateLocalSystemCredentialInfoSynchronous() {
        LocalCredentialStore localStore = LocalCredentialStore.getCredentialStore();
        if (!localStore.setUpdate(true)) {
            Trace.trace(TRACE_MASKF, "CredentialUtils.updateLocalSystemCredentialInfoSynchronous more than one update not allowed at once");
            return CredentialCompletionStatus.RESOURCE_UNAVAILABLE;
        }
        try {
            CredentialCompletionStatus status = CredentialUtils.updateSystemCredentialInfoSynchronous(null, LocalCredentialStore.getCredentialStore());
            localStore.setUpdate(false);
            return status;
        }
        catch (Exception e) {
            localStore.setUpdate(false);
            return CredentialCompletionStatus.INTERNAL_CODE_ERROR;
        }
    }

    public static CredentialCompletionStatus updateSystemCredentialInfoSynchronous(Object target, CredentialStore store) throws UnsupportedTargetException {
        return CredentialUtils.updateSystemCredentialInfoSynchronous(target, store, CredentialUtils.getSystemIdentifier(target), CredentialUtils.getClientLocation(target), CredentialUtils.getCompanyIdentifier(target), null, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CredentialCompletionStatus updateSystemCredentialInfoSynchronous(Object target, CredentialStore impl, SystemIdentifier systemIdentifier, ClientLocation clientLocation, CompanyIdentifier companyIdentifier, LicenseAcceptance licenseAcceptance, RegisterUsers registerUsers, XSeriesEnrollment xseriesEnrollment, ZSeriesEnrollment zseriesEnrollment, PSeriesEnrollment pseriesEnrollment) throws UnsupportedTargetException {
        CredentialCompletionStatus status;
        SysInfo credentials;
        Trace.trace(TRACE_MASKT, "-> CredentialUtils::updateSystemCredentialInfoSynchronous()");
        try {
            credentials = impl.getCredential(target);
        }
        catch (Exception e) {
            CredentialUtils.logError("CredentialUtils: updateSystemCredentialInfo: credentials not found", e, (short)12548);
            return CredentialCompletionStatus.INTERNAL_CODE_ERROR;
        }
        if (credentials == null) {
            CredentialUtils.logError("CredentialUtils: updateSystemCredentialInfo: credentials not found", null, (short)12548);
            return CredentialCompletionStatus.INTERNAL_CODE_ERROR;
        }
        UpdateSystemRequestBody update = new UpdateSystemRequestBody(credentials, CredentialUtils.getSystemIdentifier(target), CredentialUtils.getClientLocation(target), CredentialUtils.getCompanyIdentifier(target), null, null, null, null, null);
        CredentialResult result = new CredentialResult();
        result.setTarget(target);
        result.setStatus(CredentialCompletionStatus.RESOURCE_UNAVAILABLE);
        try {
            Trace.trace(TRACE_MASKD, "CredentialUtils: get rsf");
            RemoteSupportFacility rsf = RsfManager.getRsfManager().getConsoleRsf();
            if (rsf == null) {
                Trace.trace(TRACE_MASKD, "CredentialUtils: rsf null");
                return CredentialCompletionStatus.RESOURCE_UNAVAILABLE;
            }
            Trace.trace(TRACE_MASKD, "CredentialUtils: got RemoteSupport Facility");
            RsfRequest req = rsf.newRequestInstance(update, CLASSNAME, new LocalizableText(bundleName, "RsfCredentials.Update"));
            String id = req.getId();
            Trace.trace(TRACE_MASKD, "CredentialUtils: got new request instance:" + id);
            result.setStatus(CredentialCompletionStatus.TIMEOUT);
            outstandingRequests.put(id, result);
            req.submit();
            Trace.trace(TRACE_MASKD, "CredentialUtils: submitted request");
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "CredentialUtils: Rsf Submission Error ");
            Trace.trace(TRACE_MASKF, e);
            return CredentialCompletionStatus.RESOURCE_UNAVAILABLE;
        }
        CredentialResult credentialResult = result;
        synchronized (credentialResult) {
            if (!result.isCompleted()) {
                try {
                    result.wait(credentialTimeout);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            result.setCompleted(true);
        }
        Trace.trace(TRACE_MASKT, "<- CredentialUtils::updateSystemCredentialInfoSynchronous() Completion result= " + result.getStatus());
        String mach = "local";
        if (target != null) {
            mach = target.toString();
        }
        if ((status = result.getStatus()).equals(CredentialCompletionStatus.SUCCESS)) {
            CredentialUtils.logInfo("Update credential system info for " + mach + " machine successful", null, (short)12552);
        } else if (status.equals(CredentialCompletionStatus.TIMEOUT)) {
            CredentialUtils.logError("CredentialUtils.update system credential info: Timeout waiting for result", null, (short)12548);
        } else {
            CredentialUtils.logError("Status from update credential system info for " + mach + ": " + status, null, (short)12548);
        }
        return result.getStatus();
    }

    public static final ClientLocation getLocalClientLocation() {
        String streetAddress2;
        String streetAddress;
        String postalCode;
        String cityOrLocality;
        CustomerInfoData data = CustomerInfoManager.getCustomerInfoManager().getCustomerInfo();
        String countryCode = data.getSystemCountryCode();
        if (countryCode == null || countryCode.trim().length() == 0) {
            CredentialUtils.logError("Credential Utils: no system country code available on system", null, (short)12549);
            if (credentialDataTest) {
                countryCode = "US";
            }
        }
        String countryCodeType = "ISO2CH";
        String stateOrProvince = data.getSystemSubdivisionCode();
        if (countryCode.equals("US") && (stateOrProvince == null || stateOrProvince.trim().length() == 0)) {
            CredentialUtils.logError("Credential Utils: no system subdivision code available on system", null, (short)12549);
            if (credentialDataTest) {
                stateOrProvince = "NY";
            }
        }
        if ((cityOrLocality = data.getSystemCity()) == null || cityOrLocality.trim().length() == 0) {
            CredentialUtils.logError("Credential Utils: no system city info available on system", null, (short)12549);
            if (credentialDataTest) {
                cityOrLocality = "Endicott";
            }
        }
        if ((postalCode = data.getSystemPostalCode()) == null || postalCode.trim().length() == 0) {
            CredentialUtils.logError("Credential Utils: no postal code info available on system", null, (short)12549);
            if (credentialDataTest) {
                postalCode = "13760";
            }
        }
        if ((streetAddress = data.getSystemStreetAddr()) == null || streetAddress.trim().length() == 0) {
            CredentialUtils.logError("Credential Utils: no street address info available on system", null, (short)12549);
            if (credentialDataTest) {
                streetAddress = "1701 NorthStreet";
            }
        }
        if ((streetAddress2 = data.getSystemStreetAddr2()) != null && streetAddress2.trim().length() == 0) {
            streetAddress2 = null;
        }
        Date lastUpdateTimestamp = data.getLastUpdated();
        return new ClientLocation(countryCode, countryCodeType, stateOrProvince, cityOrLocality, postalCode, streetAddress, streetAddress2, null, null, lastUpdateTimestamp);
    }

    public static final CompanyIdentifier getLocalCompanyIdentifier() {
        CustomerInfoData data = CustomerInfoManager.getCustomerInfoManager().getCustomerInfo();
        String companyName = data.getAdminCompany();
        if (companyName == null || companyName.trim().length() == 0) {
            CredentialUtils.logError("Credential Utils: no company name info available on system", null, (short)12549);
            if (credentialDataTest) {
                companyName = "Endicott HMC Test";
            }
        }
        String companyNameForSystem = HMC.getHMC().getName();
        Trace.trace(TRACE_MASKF, "Credential Utils: system Name=" + companyNameForSystem);
        if ((companyNameForSystem == null || companyNameForSystem.trim().length() == 0) && credentialDataTest) {
            companyNameForSystem = "Test system";
        }
        Trace.trace(TRACE_MASKF, "Credential Utils: system Name=" + companyNameForSystem);
        String companyPhoneNumber = data.getAdminPhone();
        if (companyPhoneNumber == null || companyPhoneNumber.trim().length() == 0) {
            CredentialUtils.logError("Credential Utils: no company phone info available on system", null, (short)12549);
            if (credentialDataTest) {
                companyPhoneNumber = "607-752-6773";
            }
        }
        Date lastUpdateTimestamp = data.getLastUpdated();
        return new CompanyIdentifier(companyName, companyNameForSystem, companyPhoneNumber, lastUpdateTimestamp);
    }

    public static final SystemIdentifier getSystemIdentifier(Object target) throws UnsupportedTargetException {
        if (target == null) {
            return LocalCredentialStore.getLocalSystemIdentifier();
        }
        if (target instanceof String) {
            String machType = ((String)target).substring(0, 4);
            String machSerial = null;
            String machModel = null;
            int slength = ((String)target).length();
            int hyphen = ((String)target).indexOf("-");
            int asterick = ((String)target).indexOf("*");
            machSerial = asterick > 0 && asterick < slength - 1 ? ((String)target).substring(asterick + 1) : ((String)target).substring(4);
            if (asterick > 0 && hyphen > 0 && hyphen + 1 < asterick) {
                machModel = ((String)target).substring(hyphen + 1, asterick);
            }
            Date updateTimestamp = LocalCredentialStore.getCredentialStore().getInitDate();
            return new SystemIdentifier(machType, machModel, machSerial, null, updateTimestamp);
        }
        throw new UnsupportedTargetException("CredentialUtils:getSystemIdentifier currently only supports String (MTMS) targets");
    }

    public static final ClientLocation getClientLocation(Object target) throws UnsupportedTargetException {
        return CredentialUtils.getLocalClientLocation();
    }

    public static final CompanyIdentifier getCompanyIdentifier(Object target) throws UnsupportedTargetException {
        return CredentialUtils.getLocalCompanyIdentifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rsfRequestCompleted(RsfRequest request, RsfResult result) {
        Trace.trace(TRACE_MASKT, "-> CredentialUtils::rsfRequestCompleted()");
        Trace.trace(TRACE_MASKT, " CredentialUtils::rsfRequestCompleted() status=" + result.getStatusMessage());
        String requestId = request.getId();
        CredentialResult credentialResult = (CredentialResult)outstandingRequests.get(requestId);
        int status = result.getStatusCode();
        CredentialCompletionStatus credentialStatus = CredentialCompletionStatus.RESOURCE_UNAVAILABLE;
        SysInfo credentials = null;
        if (status == 1 || status == 2) {
            CredentialResult handlerResult;
            RsfResultDetails details = result.getDetails();
            if (status == 2) {
                String reasonMsg = result.getReasonMessage().toString();
                Trace.trace(TRACE_MASKF, "CredentialUtils reasonMsg=" + reasonMsg);
            }
            if ((handlerResult = (CredentialResult)details.getAttribute("Credential Result")) != null) {
                credentialStatus = handlerResult.getStatus();
                credentials = handlerResult.getCredentials();
            } else {
                Trace.trace(TRACE_MASKF, "CredentialUtils.rsfRequestCompleted - null credential result returned");
                credentialStatus = CredentialCompletionStatus.INTERNAL_CODE_ERROR;
            }
            Trace.trace(TRACE_MASKD, "CredentialUtils:rsfRequestCompleted completion status=" + credentialStatus + " credentials=" + credentials);
        }
        if (credentialResult == null) {
            Trace.trace(TRACE_MASKF, "CredentialUtils.rsfRequestCompleted null monitor");
        } else {
            CredentialResult credentialResult2 = credentialResult;
            synchronized (credentialResult2) {
                if (!credentialResult.isCompleted()) {
                    credentialResult.setStatus(credentialStatus);
                    credentialResult.setCredentials(credentials);
                    credentialResult.setCompleted(true);
                }
                credentialResult.notifyAll();
            }
        }
        Trace.trace(TRACE_MASKT, "<- CredentialUtils:rsfRequestCompleted()");
    }

    public static void startPasswordSchedule(String target, String storeName) {
        Trace.trace(TRACE_MASKT, "-> CredentialUtils::startPasswordSchedule() changePasswordFrequency: " + changePasswordFrequency + "  Change password Retry: " + changePasswordRetry);
        String[] parms = new String[]{target, storeName};
        long freq = changePasswordFrequency * 24L * 60L * 60L * 1000L;
        long woo = changePasswordRetry * 60L * 60L * 1000L * 10L;
        Date today = new Date();
        long thisTime = today.getTime();
        long start = thisTime + freq;
        Date startDate = new Date(start);
        Date lastRetryDate = new Date(start + woo);
        Trace.trace(TRACE_MASKF, "CredentialUtils.startPasswordSchedule: Today:" + today + " first update scheduled at " + startDate + " and final retry at " + lastRetryDate + " for target " + target + " and CredentialStore=" + storeName);
        HMC hmc = HMC.getHMC();
        Trace.trace(TRACE_MASKD, "CredentialUtils: get scheduler");
        HMCScheduler scheduler = HMCScheduler.getHMCScheduler();
        Trace.trace(TRACE_MASKD, "CredentialUtils: create schedule");
        ScheduledOperation schedop = null;
        try {
            Schedule sched = new Schedule(startDate, woo, -1L, freq);
            Trace.trace(TRACE_MASKD, "CredentialUtils: create scheduled operation");
            schedop = new ScheduledOperation(hmc, new ChangePasswordSchedulable(), sched, parms);
            Trace.trace(TRACE_MASKD, "CredentialUtils.add scheduled operation");
            scheduler.addScheduledOperation(schedop);
            Trace.trace(TRACE_MASKF, "CredentialUtils.scheduled operation added");
        }
        catch (Throwable e) {
            Trace.trace(TRACE_MASKF, "startPasswordSchedule: error adding schedop: " + schedop);
            Trace.trace(TRACE_MASKF, e);
            CredentialUtils.logError("CredentialUtils.startPasswordSchedule: error adding schedop", e, (short)12548);
        }
        Trace.trace(TRACE_MASKT, "<- CredentialUtils::startPasswordSchedule()");
    }

    public static void cleanupPasswordScheduleAndRemove(String target, boolean remove) {
        List schedops;
        Trace.trace(TRACE_MASKT, "-> CredentialUtils::cleanupPasswordScheduleAndRemove() target=" + target + " remove=" + remove);
        HMCScheduler scheduler = HMCScheduler.getHMCScheduler();
        HMC hmc = HMC.getHMC();
        try {
            schedops = HMCScheduler.getHMCScheduler().getScheduledOperations(hmc);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "cancelPasswordSchedule: SchedulerException");
            Trace.trace(TRACE_MASKF, e);
            CredentialUtils.logError("CredentialUtils.cleanupPasswordSchedule: error getting schedops", e, (short)12548);
            return;
        }
        boolean localFound = false;
        if (remove && target == null) {
            localFound = true;
        }
        LocalCredentialStore lcs = LocalCredentialStore.getCredentialStore();
        Iterator i = schedops.iterator();
        while (i.hasNext()) {
            ScheduledOperation schedop = (ScheduledOperation)i.next();
            if (!(schedop.getSchedulable() instanceof ChangePasswordSchedulable)) continue;
            Date createDate = schedop.getCreationDate();
            Trace.trace(TRACE_MASKF, "cleanup password schedule found schedop created on " + createDate + " : " + schedop);
            String[] parms = (String[])schedop.getOperationParameters();
            if (parms == null || parms.length < 1 || parms[0] == null) {
                if (localFound) {
                    Trace.trace(TRACE_MASKF, "cleanup password schedule: removing schedop " + schedop);
                    try {
                        scheduler.removeScheduledOperation(schedop);
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "cleanupPasswordSchedule() exception removing schedop:");
                        Trace.trace(TRACE_MASKF, e);
                        CredentialUtils.logError("CredentialUtils.cleanupPasswordSchedule: error removing schedop", e, (short)12548);
                    }
                }
                localFound = true;
                continue;
            }
            String foundTarget = parms[0];
            try {
                if (remove && foundTarget.equals(target) || lcs.getCredential(foundTarget) == null) {
                    Trace.trace(TRACE_MASKF, "Scheduled op for " + foundTarget + " will be removed.");
                    try {
                        scheduler.removeScheduledOperation(schedop);
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "cleanupPasswordSchedule() exception removing schedop:");
                        Trace.trace(TRACE_MASKF, e);
                        CredentialUtils.logError("CredentialUtils.cleanupPasswordSchedule: error removing schedop", e, (short)12548);
                    }
                    continue;
                }
                Trace.trace(TRACE_MASKF, "Credentials found for target " + target + ". Schedop won't be removed");
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "cleanupPasswordSchedule() exception getting credentials for target:");
                Trace.trace(TRACE_MASKF, e);
                CredentialUtils.logError("CredentialUtils.cleanupPasswordSchedule: exception getting credentials for target", e, (short)12548);
            }
        }
        Trace.trace(TRACE_MASKT, "<- CredentialUtils::cleanupPasswordScheduleAndRemove()");
    }

    public static void logInfo(String errorMsg, Throwable t, short errorId) {
        FrameworkLog errLog;
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLog);
    }

    public static void logError(String errorMsg, Throwable t, short errorId) {
        FrameworkLog errLog;
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLogDisplayError);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

